-- =======================================================
-- Dieses Beispiel setzt DB2 UDB V9.1 ESE mit LBAC voraus.
-- Datei NICHT ohne Anpassung ausführen!
-- Bitte lesen Sie zuerst den zugehörigen Artikel im IT-Fokus.
-- Bitte eingestreute Kommentare beachten!!
-- -------------------------------------------------------
-- Die folgenden SQL-Befehle wurden auf einem Linux-Server
-- des Autors getestet. Sie müssen auf die Verhältnisse
-- anderer DB2-Server möglicherweise angepasst werden.
-- Autor und IT-Verlag übernehmen keinerlei Gewähr,
-- dass die SQL-Befehle auf Ihrem Server oder Ihrer DB2-
-- Version lauffähig sind.
-- Sie nutzen diesen Code voll eigenverantwortlich und auf eigene Gefahr.
-- Für Schäden, Ausfälle oder Folgefehler jeglicher Art
-- haften weder Autor noch IT-Verlag.
-- Das hier gezeigte Beispiel ist nicht für den praktischen
-- Einsatz bestimmt und ist urheberrechtlich geschützt:
-- (c) Pürner Unternehmensberatung, Dortmund, 2007
-- ==========================================================
------------------------------------------------
-- DDL Statements for table "DB2INST9"."ATDATEICB"
------------------------------------------------

CREATE TABLE "DB2INST9"."ATDATEICB"  (
		  "PNR" BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (  
		    START WITH +1  
		    INCREMENT BY +1  
		    MINVALUE +1  
		    MAXVALUE +9223372036854775807  
		    NO CYCLE  
		    CACHE 25  
		    NO ORDER ) , 
		  "NAME" CHAR(24) NOT NULL , 
		  "VORNAME" CHAR(24) NOT NULL , 
		  "NAMENSZUSATZ" CHAR(24) , 
		  "HERKUNFTSLAND" CHAR(4) NOT NULL , 
		  "GESCHLECHT" CHAR(1) NOT NULL , 
		  "GEBDAT" DATE , 
		  "ERSTEINDAT" DATE NOT NULL , 
		  "LETZTEINDAT" DATE NOT NULL , 
		  "LETZTAUSDAT" DATE , 
		  "STAATSANGEH" CHAR(4) NOT NULL , 
		  "ZUST_DIENSTS_ST" CHAR(16) NOT NULL , 
		  "PROVINZ" CHAR(4) NOT NULL , 
		  "GEFEINSTUFUNG" CHAR(2) NOT NULL , 
		  "VMANNKZ" CHAR(1) , 
		  "IDKRIMREG" BIGINT , 
		  "IDTERRORNETZ" BIGINT , 
		  "BEZTERRORNETZ" CHAR(16) , 
		  "IDGEHDIENST" BIGINT )   
		 IN "USERSPACE1" ; 

COMMENT ON TABLE "DB2INST9"."ATDATEICB" IS 'Anti-Terror-Datei Costa Banana';


-- DDL Statements for primary key on Table "DB2INST9"."ATDATEICB"

ALTER TABLE "DB2INST9"."ATDATEICB" 
	ADD CONSTRAINT "PK_ATDATEICB" PRIMARY KEY
		("PNR");

-- ---------------------------------------------
-- An dieser Stelle Daten importieren:
-- DB2 Load oder Import aufrufen für Daten-Datei
-- ---------------------------------------------

-- Labels definieren

CREATE SECURITY LABEL COMPONENT SLC_LVL
ARRAY ['streng-geheim', 'geheim', 'vs', 'frei'];

CREATE SECURITY LABEL COMPONENT SLC_GKZ
ARRAY ['TT', 'AT', 'TV'];

CREATE SECURITY LABEL COMPONENT SLC_STAAT
TREE ('Zentralstaat' ROOT,
'Nordprovinz' UNDER 'Zentralstaat',
'Ostprovinz' UNDER 'Zentralstaat',
'Suedprovinz' UNDER 'Zentralstaat',
'Westprovinz' UNDER 'Zentralstaat'
);

CREATE SECURITY POLICY ANTI_TERROR_POLICY
COMPONENTS SLC_LVL, SLC_STAAT, SLC_GKZ
WITH DB2LBACRULES
RESTRICT NOT AUTHORIZED WRITE SECURITY LABEL;

CREATE SECURITY LABEL ANTI_TERROR_POLICY.VS
COMPONENT SLC_LVL 'vs';
CREATE SECURITY LABEL ANTI_TERROR_POLICY.GH
COMPONENT SLC_LVL 'geheim';
CREATE SECURITY LABEL ANTI_TERROR_POLICY.SGH
COMPONENT SLC_LVL 'streng-geheim';

CREATE SECURITY LABEL ANTI_TERROR_POLICY.NPROV_POL
COMPONENT SLC_STAAT 'Nordprovinz', COMPONENT SLC_GKZ 'TV';
CREATE SECURITY LABEL ANTI_TERROR_POLICY.OPROV_POL
COMPONENT SLC_STAAT 'Ostprovinz', COMPONENT SLC_GKZ 'TV';
CREATE SECURITY LABEL ANTI_TERROR_POLICY.SPROV_POL
COMPONENT SLC_STAAT 'Suedprovinz', COMPONENT SLC_GKZ 'TV';
CREATE SECURITY LABEL ANTI_TERROR_POLICY.WPROV_POL
COMPONENT SLC_STAAT 'Westprovinz', COMPONENT SLC_GKZ 'TV';

CREATE SECURITY LABEL ANTI_TERROR_POLICY.NPROV_SK
COMPONENT SLC_STAAT 'Nordprovinz', COMPONENT SLC_GKZ 'TT',
COMPONENT SLC_LVL 'vs';
CREATE SECURITY LABEL ANTI_TERROR_POLICY.OPROV_SK
COMPONENT SLC_STAAT 'Ostprovinz', COMPONENT SLC_GKZ 'TT',
COMPONENT SLC_LVL 'vs';
CREATE SECURITY LABEL ANTI_TERROR_POLICY.WPROV_SK
COMPONENT SLC_STAAT 'Westprovinz', COMPONENT SLC_GKZ 'TT',
COMPONENT SLC_LVL 'vs';
CREATE SECURITY LABEL ANTI_TERROR_POLICY.SPROV_SK
COMPONENT SLC_STAAT 'Suedprovinz', COMPONENT SLC_GKZ 'TT',
COMPONENT SLC_LVL 'vs';

CREATE SECURITY LABEL ANTI_TERROR_POLICY.GHD
COMPONENT SLC_STAAT 'Zentralstaat', COMPONENT SLC_GKZ 'TT',
COMPONENT SLC_LVL 'streng-geheim';


CREATE SECURITY LABEL ANTI_TERROR_POLICY.NPROV_KD
COMPONENT SLC_STAAT 'Nordprovinz', COMPONENT SLC_GKZ 'AT';
CREATE SECURITY LABEL ANTI_TERROR_POLICY.OPROV_KD
COMPONENT SLC_STAAT 'Ostprovinz', COMPONENT SLC_GKZ 'AT';
CREATE SECURITY LABEL ANTI_TERROR_POLICY.SPROV_KD
COMPONENT SLC_STAAT 'Suedprovinz', COMPONENT SLC_GKZ 'AT';
CREATE SECURITY LABEL ANTI_TERROR_POLICY.WPROV_KD
COMPONENT SLC_STAAT 'Westprovinz', COMPONENT SLC_GKZ 'AT';


GRANT SECURITY LABEL ANTI_TERROR_POLICY.GHD
TO USER db2inst9
FOR ALL ACCESS;

GRANT EXEMPTION ON RULE ALL
FOR ANTI_TERROR_POLICY
TO USER db2inst9;

-- Tabelle mit Labels sichern

ALTER TABLE "DB2INST9"."ATDATEICB"
ADD COLUMN POL_TAG DB2SECURITYLABEL
ADD SECURITY POLICY ANTI_TERROR_POLICY;

ALTER TABLE "DB2INST9"."ATDATEICB"
ALTER COLUMN GEFEINSTUFUNG SECURED WITH VS
ALTER COLUMN IDKRIMREG SECURED WITH VS
ALTER COLUMN IDTERRORNETZ SECURED WITH VS
ALTER COLUMN BEZTERRORNETZ SECURED WITH VS
ALTER COLUMN IDGEHDIENST SECURED WITH GH
ALTER COLUMN VMANNKZ SECURED WITH SGH
;

-- Labels in Tabelle erzeugen

UPDATE ATDATEICB
set POL_TAG= SECLABEL_BY_NAME ('ANTI_TERROR_POLICY', 'NPROV_POL')
where PROVINZ='Nord' and GEFEINSTUFUNG = 'TV';
UPDATE ATDATEICB
set POL_TAG= SECLABEL_BY_NAME ('ANTI_TERROR_POLICY', 'OPROV_POL')
where PROVINZ='Ost' and GEFEINSTUFUNG = 'TV';
UPDATE ATDATEICB
set POL_TAG= SECLABEL_BY_NAME ('ANTI_TERROR_POLICY', 'WPROV_POL')
where PROVINZ='West' and GEFEINSTUFUNG = 'TV';
UPDATE ATDATEICB
set POL_TAG= SECLABEL_BY_NAME ('ANTI_TERROR_POLICY', 'SPROV_POL')
where PROVINZ='Sued' and GEFEINSTUFUNG = 'TV';

UPDATE ATDATEICB
set POL_TAG= SECLABEL_BY_NAME ('ANTI_TERROR_POLICY', 'NPROV_KD')
where PROVINZ='Nord' and GEFEINSTUFUNG = 'AT';
UPDATE ATDATEICB
set POL_TAG= SECLABEL_BY_NAME ('ANTI_TERROR_POLICY', 'OPROV_KD')
where PROVINZ='Ost' and GEFEINSTUFUNG = 'AT';
UPDATE ATDATEICB
set POL_TAG= SECLABEL_BY_NAME ('ANTI_TERROR_POLICY', 'WPROV_KD')
where PROVINZ='West' and GEFEINSTUFUNG = 'AT';
UPDATE ATDATEICB
set POL_TAG= SECLABEL_BY_NAME ('ANTI_TERROR_POLICY', 'SPROV_KD')
where PROVINZ='Sued' and GEFEINSTUFUNG = 'AT';

UPDATE ATDATEICB
set POL_TAG= SECLABEL_BY_NAME ('ANTI_TERROR_POLICY', 'NPROV_SK')
where PROVINZ='Nord' and GEFEINSTUFUNG = 'TT';
UPDATE ATDATEICB
set POL_TAG= SECLABEL_BY_NAME ('ANTI_TERROR_POLICY', 'OPROV_SK')
where PROVINZ='Ost' and GEFEINSTUFUNG = 'TT';
UPDATE ATDATEICB
set POL_TAG= SECLABEL_BY_NAME ('ANTI_TERROR_POLICY', 'WPROV_SK')
where PROVINZ='West' and GEFEINSTUFUNG = 'TT';
UPDATE ATDATEICB
set POL_TAG= SECLABEL_BY_NAME ('ANTI_TERROR_POLICY', 'SPROV_SK')
where PROVINZ='Sued' and GEFEINSTUFUNG = 'TT';

select name, provinz, seclabel_to_char('ANTI_TERROR_POLICY', POL_TAG)  from atdateicb;

-------------------------------------------------------------
-- Achtung:
-- Es wird vorausgesetzt, dass die User-IDs angelegt sind
-- DB2 erwartet üblicherweise, dass die User-IDs auf OS-Ebene
-- definiert und dann ins DB2 übernommen werden.
--------------------------------------------------------------


GRANT SECURITY LABEL ANTI_TERROR_POLICY.GHD
TO USER bond FOR ALL ACCESS;

CREATE SECURITY LABEL ANTI_TERROR_POLICY.NPOL
COMPONENT SLC_STAAT 'Nordprovinz', COMPONENT SLC_GKZ 'TV',
COMPONENT SLC_LVL 'frei';
CREATE SECURITY LABEL ANTI_TERROR_POLICY.OKD
COMPONENT SLC_STAAT 'Ostprovinz', COMPONENT SLC_GKZ 'AT',
COMPONENT SLC_LVL 'frei';
CREATE SECURITY LABEL ANTI_TERROR_POLICY.WSK
COMPONENT SLC_STAAT 'Westprovinz', COMPONENT SLC_GKZ 'TT',
COMPONENT SLC_LVL 'vs';

CREATE SECURITY LABEL ANTI_TERROR_POLICY.GHM
COMPONENT SLC_STAAT 'Zentralstaat', COMPONENT SLC_GKZ 'TT',
COMPONENT SLC_LVL 'geheim';

GRANT SECURITY LABEL ANTI_TERROR_POLICY.NPOL
TO USER harry FOR READ ACCESS;
GRANT SECURITY LABEL ANTI_TERROR_POLICY.OKD
TO USER derrick FOR READ ACCESS;
GRANT SECURITY LABEL ANTI_TERROR_POLICY.WSK
TO USER soko FOR ALL ACCESS;
GRANT SECURITY LABEL ANTI_TERROR_POLICY.GHM
TO USER schlphut FOR ALL ACCESS;


-- ================================================
-- Achtung: Hier beginnen die Auswertungen
--          SQL-Befehle und Ergebnisse
-- ------------------------------------------
-- Harry - Polizist Nordprovinz:

select 
NAME , VORNAME,NAMENSZUSATZ,HERKUNFTSLAND, GESCHLECHT,GEBDAT, ERSTEINDAT, LETZTEINDAT,
 LETZTAUSDAT , STAATSANGEH,ZUST_DIENSTS_ST, seclabel_to_char('ANTI_TERROR_POLICY', POL_TAG) 
 from db2inst9.atdateicb;

NAME                     VORNAME                  NAMENSZUSATZ             HERKUNFTSLAND GESCHLECHT GEBDAT     ERSTEINDAT LETZTEINDAT LETZTAUSDAT STAATSANGEH ZUST_DIENSTS_ST  12                
------------------------ ------------------------ ------------------------ ------------- ---------- ---------- ---------- ----------- ----------- ----------- ---------------- ------------------
HAAS                     CHRISTINE                -                        AUS           F          1963-08-24 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
THOMPSON                 MICHAEL                  -                        TELA          M          1978-02-02 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
KWAN                     SALLY                    -                        USA           F          1971-05-11 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
STERN                    IRVING                   -                        TELA          M          1975-07-07 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
PULASKI                  EVA                      -                        TELA          F          2003-05-26 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
HENDERSON                EILEEN                   -                        TELA          F          1971-05-15 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
SPENSER                  THEODORE                 -                        TELA          M          1980-12-18 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
OCONNELL                 SEAN                     -                        IRL           M          1972-10-18 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
NICHOLLS                 HEATHER                  -                        TELA          F          1976-01-19 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
ADAMSON                  BRUCE                    -                        TELA          M          1977-05-17 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
PIANKA                   ELIZABETH                -                        TELA          F          1980-04-12 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
SCOUTTEN                 MARILYN                                           TELA          F          1979-02-21 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
BROWN                    DAVID                    -                        TELA          M          1971-05-29 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
LUTZ                     JENNIFER                 -                        TELA          F          1978-03-19 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
JEFFERSON                JAMES                    -                        TELA          M          1980-05-30 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
MARINO                   SALVATORE                -                        TELA          M          2002-03-31 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
JOHNSON                  SYBIL                    -                        TELA          F          1976-10-05 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
PEREZ                    MARIA                    -                        TELA          F          2003-05-26 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
PARKER                   JOHN                     -                        TELA          M          1985-07-09 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
SMITH                    PHILIP                   -                        TELA          M          1976-10-27 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
SETRIGHT                 MAUDE                    -                        TELA          F          1961-04-21 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
LEE                      WING                     -                        TELA          M          1971-07-18 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
GOUNOT                   JASON                    -                        TELA          M          1956-05-17 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
HEMMINGER                DIAN                     -                        TELA          F          1973-08-14 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
ORLANDO                  GREG                     -                        TELA          M          1972-10-18 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
NATZ                     KIM                      -                        TELA          F          1976-01-19 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
YAMAMOTO                 KIYOSHI                  Kamikaze                 TELA          M          1981-01-05 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
JOHN                     REBA                     -                        TELA          F          1978-03-19 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
MONTEVERDE               ROBERT                   -                        TELA          M          1984-03-31 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
SCHWARTZ                 EILEEN                   -                        TELA          F          1966-03-28 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
SPRINGER                 MICHELLE                 -                        TELA          F          1961-04-21 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 
WONG                     HELENA                   -                        TELA          F          1971-07-18 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Nordprovinz:TV 

  32 record(s) selected.

-- Derrick - Kriminaldirektor Ost:

select NAME , VORNAME,NAMENSZUSATZ,HERKUNFTSLAND, GESCHLECHT,GEBDAT, ERSTEINDAT, LETZTEINDAT, LETZTAUSDAT 
, STAATSANGEH,ZUST_DIENSTS_ST, substr(seclabel_to_char('ANTI_TERROR_POLICY', POL_TAG),1,18)
from db2inst9.atdateicb;

NAME                     VORNAME                  NAMENSZUSATZ             HERKUNFTSLAND GESCHLECHT GEBDAT     ERSTEINDAT LETZTEINDAT LETZTAUSDAT STAATSANGEH ZUST_DIENSTS_ST  12                
------------------------ ------------------------ ------------------------ ------------- ---------- ---------- ---------- ----------- ----------- ----------- ---------------- ------------------
MEHTA                    RAMLAL                   -                        IND           M          1962-08-11 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Ostprovinz:TV  
ALONZO                   ROY                      -                        MEX           M          1956-05-17 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Ostprovinz:AT  

  2 record(s) selected.


-- Soko - Sonderkommission Anti-Terror Westprovinz:

select NAME , VORNAME,NAMENSZUSATZ,HERKUNFTSLAND, GESCHLECHT,GEBDAT, ERSTEINDAT, LETZTEINDAT, LETZTAUSDAT 
, STAATSANGEH,ZUST_DIENSTS_ST, substr(seclabel_to_char('ANTI_TERROR_POLICY', POL_TAG),1,18)
from db2inst9.atdateicb;


NAME                     VORNAME                  NAMENSZUSATZ             HERKUNFTSLAND GESCHLECHT GEBDAT     ERSTEINDAT LETZTEINDAT LETZTAUSDAT STAATSANGEH ZUST_DIENSTS_ST  12                
------------------------ ------------------------ ------------------------ ------------- ---------- ---------- ---------- ----------- ----------- ----------- ---------------- ------------------
GEYER                    JOHN                     -                        TELA          M          1955-09-15 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Westprovinz:TV 
WALKER                   Johnny                   Die Flasche              SCTL          M          1982-06-25 2006-09-13 2006-09-13  -           BRIT        1.Kommissariat   ():Westprovinz:TV 
SMITH                    DANIEL                   -                        TELA          M          1969-11-12 2006-09-13 2006-09-13  -           COBA        1.Kommissariat   ():Westprovinz:TV 
Bush                     George                   The Warrior              USA           M          1944-02-29 1996-01-01 2006-01-01  1997-12-05  US          3.SK Kölsch      vs:Westprovinz:TT 
Ente                     Dagobert                 Duck                     DISN          M          1872-01-01 1900-06-02 1900-06-02  -           ENTE        WaschPo          ():Westprovinz:AT 

  5 record(s) selected.

select NAME , VORNAME,NAMENSZUSATZ,HERKUNFTSLAND, GESCHLECHT,GEBDAT, ERSTEINDAT, LETZTEINDAT, GEFEINSTUFUNG
, STAATSANGEH,ZUST_DIENSTS_ST, IDKRIMREG , IDTERRORNETZ,  BEZTERRORNETZ,
 substr(seclabel_to_char('ANTI_TERROR_POLICY', POL_TAG),1,18)
from db2inst9.atdateicb;

NAME                     VORNAME                  NAMENSZUSATZ             HERKUNFTSLAND GESCHLECHT GEBDAT     ERSTEINDAT LETZTEINDAT GEFEINSTUFUNG STAATSANGEH ZUST_DIENSTS_ST  IDKRIMREG            IDTERRORNETZ         BEZTERRORNETZ    15                
------------------------ ------------------------ ------------------------ ------------- ---------- ---------- ---------- ----------- ------------- ----------- ---------------- -------------------- -------------------- ---------------- ------------------
GEYER                    JOHN                     -                        TELA          M          1955-09-15 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      -                    - -                ():Westprovinz:TV 
WALKER                   Johnny                   Die Flasche              SCTL          M          1982-06-25 2006-09-13 2006-09-13  TV            BRIT        1.Kommissariat                      -                    - -                ():Westprovinz:TV 
SMITH                    DANIEL                   -                        TELA          M          1969-11-12 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      -                    - -                ():Westprovinz:TV 
Bush                     George                   The Warrior              USA           M          1944-02-29 1996-01-01 2006-01-01  TT            US          3.SK Kölsch                    123455                    8 WhiteHouse Gang  vs:Westprovinz:TT 
Ente                     Dagobert                 Duck                     DISN          M          1872-01-01 1900-06-02 1900-06-02  AT            ENTE        WaschPo                         13455                    - -                ():Westprovinz:AT 

  5 record(s) selected.

-- Schlphut -  Special Agent Schlapphut vom Geheimdienst:

select NAME , VORNAME,NAMENSZUSATZ,HERKUNFTSLAND, GESCHLECHT,GEBDAT, ERSTEINDAT, LETZTEINDAT, GEFEINSTUFUNG
, STAATSANGEH,ZUST_DIENSTS_ST, IDKRIMREG ,BEZTERRORNETZ, IDGEHDIENST,
 substr(seclabel_to_char('ANTI_TERROR_POLICY', POL_TAG),1,18)
from db2inst9.atdateicb;

NAME                     VORNAME                  NAMENSZUSATZ    HERKUNFTSLAND GESCHLECHT GEBDAT     ERSTEINDAT LETZTEINDAT GEFEINSTUFUNG STAATSANGEH ZUST_DIENSTS_ST  IDKRIMREG            BEZTERRORNETZ    IDGEHDIENST          15                
------------------------ ------------------------ --------------- ------------- ---------- ---------- ---------- ----------- ------------- ----------- ---------------- -------------------- ---------------- -------------------- ------------------
HAAS                     CHRISTINE                -               AUS           F          1963-08-24 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
THOMPSON                 MICHAEL                  -               TELA          M          1978-02-02 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
KWAN                     SALLY                    -               USA           F          1971-05-11 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - WhiteHouse Gang                     - ():Nordprovinz:TV 
GEYER                    JOHN                     -               TELA          M          1955-09-15 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Westprovinz:TV 
STERN                    IRVING                   -               TELA          M          1975-07-07 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
PULASKI                  EVA                      -               TELA          F          2003-05-26 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
HENDERSON                EILEEN                   -               TELA          F          1971-05-15 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
SPENSER                  THEODORE                 -               TELA          M          1980-12-18 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
LUCCHESSI                VINCENZO                 El Mafioso      ITA           M          1959-11-05 2006-09-13 2006-09-13  AT            ITA         1.Kommissariat                      - -                                   - ():Suedprovinz:AT 
OCONNELL                 SEAN                     -               IRL           M          1972-10-18 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
QUINTANA                 DELORES                  -               TELA          F          1955-09-15 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Suedprovinz:TV 
NICHOLLS                 HEATHER                  -               TELA          F          1976-01-19 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
ADAMSON                  BRUCE                    -               TELA          M          1977-05-17 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
PIANKA                   ELIZABETH                -               TELA          F          1980-04-12 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
SCOUTTEN                 MARILYN                                  TELA          F          1979-02-21 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
WALKER                   Johnny                   Die Flasche     SCTL          M          1982-06-25 2006-09-13 2006-09-13  TV            BRIT        1.Kommissariat                      - -                                   - ():Westprovinz:TV 
BROWN                    DAVID                    -               TELA          M          1971-05-29 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
JONES                    WILLIAM                  -               TELA          M          2003-02-23 2006-09-13 2006-09-13  AT            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:AT 
LUTZ                     JENNIFER                 -               TELA          F          1978-03-19 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
JEFFERSON                JAMES                    -               TELA          M          1980-05-30 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
MARINO                   SALVATORE                -               TELA          M          2002-03-31 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
SMITH                    DANIEL                   -               TELA          M          1969-11-12 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Westprovinz:TV 
JOHNSON                  SYBIL                    -               TELA          F          1976-10-05 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
PEREZ                    MARIA                    -               TELA          F          2003-05-26 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                 456728 El KeinerDa                         - ():Nordprovinz:TV 
SCHNEIDER                ETHEL                    -               TELA          F          1976-03-28 2006-09-13 2006-09-13  AT            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:AT 
PARKER                   JOHN                     -               TELA          M          1985-07-09 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
SMITH                    PHILIP                   -               TELA          M          1976-10-27 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
SETRIGHT                 MAUDE                    -               TELA          F          1961-04-21 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
MEHTA                    RAMLAL                   -               IND           M          1962-08-11 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Ostprovinz:TV  
LEE                      WING                     -               TELA          M          1971-07-18 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
GOUNOT                   JASON                    -               TELA          M          1956-05-17 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
HEMMINGER                DIAN                     -               TELA          F          1973-08-14 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
ORLANDO                  GREG                     -               TELA          M          1972-10-18 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
NATZ                     KIM                      -               TELA          F          1976-01-19 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
YAMAMOTO                 KIYOSHI                  Kamikaze        TELA          M          1981-01-05 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
JOHN                     REBA                     -               TELA          F          1978-03-19 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
MONTEVERDE               ROBERT                   -               TELA          M          1984-03-31 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
SCHWARTZ                 EILEEN                   -               TELA          F          1966-03-28 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
SPRINGER                 MICHELLE                 -               TELA          F          1961-04-21 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
WONG                     HELENA                   -               TELA          F          1971-07-18 2006-09-13 2006-09-13  TV            COBA        1.Kommissariat                      - -                                   - ():Nordprovinz:TV 
ALONZO                   ROY                      -               MEX           M          1956-05-17 2006-09-13 2006-09-13  AT            COBA        1.Kommissariat                      - -                                   - ():Ostprovinz:AT  
BinImLaden               Ossy                     Der Araber      TELA          M          1949-04-17 1999-09-10 2006-10-01  TT            DEUT        2.Kommissariat                   4711 El KeinerDa                      4712 vs:Suedprovinz:TT 
Bush                     George                   The Warrior     USA           M          1944-02-29 1996-01-01 2006-01-01  TT            US          3.SK Kölsch                    123455 WhiteHouse Gang                876554 vs:Westprovinz:TT 
Fisher                   Jogi                     Moltow-Cocktail DEUT          M          1955-05-07 2004-08-01 2004-08-01  TT            COBA        AutobahnPolizei                     - RAF                             87621 vs:Ostprovinz:TT  
Ente                     Dagobert                 Duck            DISN          M          1872-01-01 1900-06-02 1900-06-02  AT            ENTE        WaschPo                         13455 -                                   - ():Westprovinz:AT 

  45 record(s) selected.


-- Bond - Special Agent James Bond mit Sonderbefugnissen:

select NAME ,NAMENSZUSATZ,HERKUNFTSLAND, GEBDAT, GEFEINSTUFUNG , STAATSANGEH
, ZUST_DIENSTS_ST, IDKRIMREG ,BEZTERRORNETZ, IDGEHDIENST
, substr(seclabel_to_char('ANTI_TERROR_POLICY', POL_TAG),1,18)
 from db2inst9.atdateicb
 where vmannkz is not null;

NAME                     NAMENSZUSATZ             HERKUNFTSLAND GEBDAT     GEFEINSTUFUNG STAATSANGEH ZUST_DIENSTS_ST  IDKRIMREG            BEZTERRORNETZ    IDGEHDIENST          11                
------------------------ ------------------------ ------------- ---------- ------------- ----------- ---------------- -------------------- ---------------- -------------------- ------------------
BinImLaden               Der Araber               TELA          1949-04-17 TT            DEUT        2.Kommissariat                   4711 El KeinerDa                      4712 vs:Suedprovinz:TT 
Fisher                   Moltow-Cocktail          DEUT          1955-05-07 TT            COBA        AutobahnPolizei                     - RAF                             87621 vs:Ostprovinz:TT  
Ente                     Duck                     DISN          1872-01-01 AT            ENTE        WaschPo                         13455 -                                   - ():Westprovinz:AT 

  3 record(s) selected.


-- Fehlermeldung bei fehlender Spalten-Berechtigung:

SQL20264N For table "ATDATEICB", authorization ID "HARRY" does not have "READ" 
access to the column "VMANNKZ".  SQLSTATE=42512
