-- =======================================================
-- Dieses Beispiel setzt Oracle 10g EE mit OLS voraus.
-- Datei NICHT ohne Anpassung ausführen!
-- Bitte lesen Sie zuerst den zugehörigen Artikel im IT-Fokus.
-- Bitte eingestreute Kommentare beachten!!
-- -------------------------------------------------------
-- Die folgenden SQL-Befehle wurden auf einem Linux-Server
-- des Autors getestet. Sie müssen auf die Verhältnisse
-- anderer Oracle-Server möglicherweise angepasst werden.
-- Autor und IT-Verlag übernehmen keinerlei Gewähr,
-- dass die SQL-Befehle auf Ihrem Server oder Ihrer Oracle-
-- Version lauffähig sind.
-- Sie nutzen diesen Code voll eigenverantwortlich und auf eigene Gefahr.
-- Für Schäden, Ausfälle oder Folgefehler jeglicher Art
-- haften weder Autor noch IT-Verlag.
-- Das hier gezeigte Beispiel ist nicht für den praktischen
-- Einsatz bestimmt und ist urheberrechtlich geschützt:
-- (c) Pürner Unternehmensberatung, Dortmund, 2007
-- ==========================================================

------------------------------------------------
-- DDL Statements for table "BI"."ATDATEICB"
------------------------------------------------
 

CREATE TABLE "BI"."ATDATEICB"  (
		  "PNR" INTEGER, 
		  "NAME" CHAR(24) NOT NULL , 
		  "VORNAME" CHAR(24) NOT NULL , 
		  "NAMENSZUSATZ" CHAR(24) , 
		  "HERKUNFTSLAND" CHAR(4) NOT NULL , 
		  "GESCHLECHT" CHAR(1) NOT NULL , 
		  "GEBDAT" DATE , 
		  "ERSTEINDAT" DATE NOT NULL , 
		  "LETZTEINDAT" DATE NOT NULL , 
		  "LETZTAUSDAT" DATE , 
		  "STAATSANGEH" CHAR(4) NOT NULL , 
		  "ZUST_DIENSTS_ST" CHAR(16) NOT NULL , 
		  "PROVINZ" CHAR(4) NOT NULL , 
		  "GEFEINSTUFUNG" CHAR(2) NOT NULL , 
		  "VMANNKZ" CHAR(1) , 
		  "IDKRIMREG" INTEGER , 
		  "IDTERRORNETZ" INTEGER , 
		  "BEZTERRORNETZ" CHAR(16) , 
		  "IDGEHDIENST" INTEGER )   
		  ; 

COMMENT ON TABLE "BI"."ATDATEICB" IS 'Anti-Terror-Datei Costa Banana';


-- DDL Statements for primary key on Table "BI"."ATDATEICB"

ALTER TABLE "BI"."ATDATEICB" 
	ADD CONSTRAINT "PK_ATDATEICB" PRIMARY KEY
		("PNR");

CREATE SEQUENCE "BI"."TER_NUM" INCREMENT BY 1 START WITH 1 
    MAXVALUE 1.0E28 MINVALUE 1 NOCYCLE 
    CACHE 20 ORDER

-- ---------------------------------------------
-- An dieser Stelle Daten importieren:
-- SQL Loader oder Import aufrufen für Daten-Datei
-- ---------------------------------------------

-- Policy und Labels definieren

begin
   SA_SYSDBA.CREATE_POLICY( 
       policy_name => 'ANTI_TERROR_POLICY' 
      ,column_name => 'POL_TAG' 
      ,default_options => 'ALL_CONTROL,HIDE' 
   );
end;
/



begin
   SA_COMPONENTS.CREATE_LEVEL( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,level_num =>   1000 
      ,short_name => 'TV' 
      ,long_name => 'Terror Verdaechtig' 
   );
   SA_COMPONENTS.CREATE_LEVEL( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,level_num => 2000 
      ,short_name => 'AT' 
      ,long_name => 'Aktiver Terrorist' 
   );
   SA_COMPONENTS.CREATE_LEVEL( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,level_num => 4000 
      ,short_name => 'TT' 
      ,long_name => 'Top Terrorist' 
   );
end;
/



begin
   SA_COMPONENTS.CREATE_GROUP( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,group_num =>   0 
      ,short_name => 'ZS' 
      ,long_name => 'Zentralstaat' 
      ,parent_name => NULL 
   );
   SA_COMPONENTS.CREATE_GROUP( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,group_num =>   10 
      ,short_name => 'NP' 
      ,long_name => 'Nordprovinz' 
      ,parent_name => 'ZS' 
   );
   SA_COMPONENTS.CREATE_GROUP( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,group_num =>   20 
      ,short_name => 'OP' 
      ,long_name => 'Ostprovinz' 
      ,parent_name => 'ZS' 
   );
   SA_COMPONENTS.CREATE_GROUP( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,group_num =>   30 
      ,short_name => 'WP' 
      ,long_name => 'Westprovinz' 
      ,parent_name => 'ZS' 
   );
   SA_COMPONENTS.CREATE_GROUP( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,group_num =>   40 
      ,short_name => 'SP' 
      ,long_name => 'Suedprovinz' 
      ,parent_name => 'ZS' 
   );
end;
/

-- Tabelle mit Labels sichern

begin
SA_POLICY_ADMIN.APPLY_TABLE_POLICY( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,schema_name => 'BI'  
      ,table_name => 'ATDATEICB' 
      ,table_options => NULL 
      ,label_function => NULL 
      ,predicate => NULL 
   );
end;
/


begin
   SA_LABEL_ADMIN.CREATE_LABEL( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,label_tag =>   501 
     ,label_value => 'TV::NP' 
      ,data_label => TRUE 
   );
   SA_LABEL_ADMIN.CREATE_LABEL( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,label_tag =>   502 
      ,label_value => 'AT::NP' 
      ,data_label => TRUE 
   );
   SA_LABEL_ADMIN.CREATE_LABEL( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,label_tag =>   503 
      ,label_value => 'TT::NP' 
      ,data_label => TRUE 
   );
   SA_LABEL_ADMIN.CREATE_LABEL( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,label_tag =>   511 
     ,label_value => 'TV::OP' 
      ,data_label => TRUE 
   );
   SA_LABEL_ADMIN.CREATE_LABEL( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,label_tag =>   512 
      ,label_value => 'AT::OP' 
      ,data_label => TRUE 
   );
   SA_LABEL_ADMIN.CREATE_LABEL( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,label_tag =>   513 
      ,label_value => 'TT::OP' 
      ,data_label => TRUE 
   );
   SA_LABEL_ADMIN.CREATE_LABEL( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,label_tag =>   521 
     ,label_value => 'TV::WP' 
      ,data_label => TRUE 
   );
   SA_LABEL_ADMIN.CREATE_LABEL( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,label_tag =>   522 
      ,label_value => 'AT::WP' 
      ,data_label => TRUE 
   );
   SA_LABEL_ADMIN.CREATE_LABEL( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,label_tag =>   523 
      ,label_value => 'TT::WP' 
      ,data_label => TRUE 
   );
   SA_LABEL_ADMIN.CREATE_LABEL( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,label_tag =>   541 
     ,label_value => 'TV::SP' 
      ,data_label => TRUE 
   );
   SA_LABEL_ADMIN.CREATE_LABEL( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,label_tag =>   542 
      ,label_value => 'AT::SP' 
      ,data_label => TRUE 
   );
   SA_LABEL_ADMIN.CREATE_LABEL( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,label_tag =>   543 
      ,label_value => 'TT::SP' 
      ,data_label => TRUE 
   );
end;
/

-------------------------------------------------------------
-- Achtung:
-- Es wird vorausgesetzt, dass die User-IDs angelegt sind
--------------------------------------------------------------

begin
   SA_USER_ADMIN.SET_USER_LABELS( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,user_name =>   'HARRY' 
      ,max_read_label => 'TV::NP' 
   );
   SA_USER_ADMIN.SET_USER_LABELS( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,user_name =>   'DERRICK' 
      ,max_read_label => 'AT::OP' 
   );
   SA_USER_ADMIN.SET_USER_LABELS( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,user_name =>   'SOKO' 
      ,max_read_label => 'TT::WP' 
   );
   SA_USER_ADMIN.SET_USER_LABELS( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,user_name =>   'SCHLPHUT' 
      ,max_read_label => 'TT::ZS' 
   );
   SA_USER_ADMIN.SET_USER_LABELS( 
       policy_name => 'ANTI_TERROR_POLICY'  
      ,user_name =>   'BOND' 
      ,max_read_label => 'TT::ZS' 
   );
end;
/



-- Labels in Tabelle erzeugen

UPDATE BI.ATDATEICB
set POL_TAG= CHAR_TO_LABEL ('ANTI_TERROR_POLICY', 'TV::NP')
where PROVINZ='Nord' and GEFEINSTUFUNG = 'TV';
UPDATE BI.ATDATEICB
set POL_TAG= CHAR_TO_LABEL ('ANTI_TERROR_POLICY', 'TV::OP')
where PROVINZ='Ost' and GEFEINSTUFUNG = 'TV';
UPDATE BI.ATDATEICB
set POL_TAG= CHAR_TO_LABEL ('ANTI_TERROR_POLICY', 'TV::WP')
where PROVINZ='West' and GEFEINSTUFUNG = 'TV';
UPDATE BI.ATDATEICB
set POL_TAG= CHAR_TO_LABEL ('ANTI_TERROR_POLICY', 'TV::SP')
where PROVINZ='Sued' and GEFEINSTUFUNG = 'TV';

UPDATE BI.ATDATEICB
set POL_TAG= CHAR_TO_LABEL ('ANTI_TERROR_POLICY', 'AT::NP')
where PROVINZ='Nord' and GEFEINSTUFUNG = 'AT';
UPDATE BI.ATDATEICB
set POL_TAG= CHAR_TO_LABEL ('ANTI_TERROR_POLICY', 'AT::OP')
where PROVINZ='Ost' and GEFEINSTUFUNG = 'AT';
UPDATE BI.ATDATEICB
set POL_TAG= CHAR_TO_LABEL ('ANTI_TERROR_POLICY', 'AT::WP')
where PROVINZ='West' and GEFEINSTUFUNG = 'AT';
UPDATE BI.ATDATEICB
set POL_TAG= CHAR_TO_LABEL ('ANTI_TERROR_POLICY', 'AT::SP')
where PROVINZ='Sued' and GEFEINSTUFUNG = 'AT';

UPDATE BI.ATDATEICB
set POL_TAG= CHAR_TO_LABEL ('ANTI_TERROR_POLICY', 'TT::NP')
where PROVINZ='Nord' and GEFEINSTUFUNG = 'TT';
UPDATE BI.ATDATEICB
set POL_TAG= CHAR_TO_LABEL ('ANTI_TERROR_POLICY', 'TT::OP')
where PROVINZ='Ost' and GEFEINSTUFUNG = 'TT';
UPDATE BI.ATDATEICB
set POL_TAG= CHAR_TO_LABEL ('ANTI_TERROR_POLICY', 'TT::WP')
where PROVINZ='West' and GEFEINSTUFUNG = 'TT';
UPDATE BI.ATDATEICB
set POL_TAG= CHAR_TO_LABEL ('ANTI_TERROR_POLICY', 'TT::SP')
where PROVINZ='Sued' and GEFEINSTUFUNG = 'TT';

select pnr, name, provinz, substr(label_to_char(POL_TAG),1,16)  from BI.ATDATEICB;

---------------------------------------------------

-- Column Level Security nachbilden in VPD


CREATE TABLE "BI"."USER_ACCESS"  (
		  "UID"     VARCHAR2(24) NOT NULL PRIMARY KEY, 
		  "VSSTUFE" VARCHAR2(16) NOT NULL )   
		  ; 

create or replace package at_spalten
as
 function at_sp1(p_schema in varchar2, p_table in varchar2)
 return varchar2;
 function at_sp2(p_schema in varchar2, p_table in varchar2)
 return varchar2;
 function at_sp3(p_schema in varchar2, p_table in varchar2)
 return varchar2;
end;
/

create or replace package body at_spalten
as
function at_sp1 (
   p_schema in varchar2,
   p_table in varchar2
)
   return varchar2
is
   retstr varchar2(200):='';
   zahl integer:= 0;
begin
       select count(*) into zahl
         from bi.user_access
         where "UID" = SYS_CONTEXT('USERENV','SESSION_USER') 
         and VSSTUFE in ('streng-geheim', 'geheim', 'vs'); 
      retstr := '1 = '||zahl;
   return retstr;
end;
--
function at_sp2 (
   p_schema in varchar2,
   p_table in varchar2
)
   return varchar2
is
   retstr varchar2(200):='';
   zahl integer:= 0;
begin
       select count(*) into zahl
         from bi.user_access
         where "UID" = SYS_CONTEXT('USERENV','SESSION_USER') 
         and VSSTUFE in ('streng-geheim', 'geheim'); 
      retstr := '1 = '||zahl;
   return retstr;
end;
--
function at_sp3 (
   p_schema in varchar2,
   p_table in varchar2
)
   return varchar2
is
   retstr varchar2(200):='';
   zahl integer:= 0;
begin
       select count(*) into zahl
         from bi.user_access
         where "UID" = SYS_CONTEXT('USERENV','SESSION_USER') 
         and VSSTUFE = 'streng-geheim'; 
      retstr := '1 = '||zahl;
   return retstr;
end;
end; --- end package body


begin
DBMS_RLS.add_policy (
    object_schema     => 'BI',
    object_name       => 'ATDATEICB',
    policy_name       => 'AT_SP1_POLICY',
    function_schema   => 'SYSMAN',
    policy_function   => 'AT_SPALTEN.AT_SP1',
    sec_relevant_cols => 'GEFEINSTUFUNG, IDKRIMREG, IDTERRORNETZ, BEZTERRORNETZ'
 );
DBMS_RLS.add_policy (
    object_schema     => 'BI',
    object_name       => 'ATDATEICB',
    policy_name       => 'AT_SP2_POLICY',
    function_schema   => 'SYSMAN',
    policy_function   => 'AT_SPALTEN.AT_SP2',
    sec_relevant_cols => 'IDGEHDIENST'
 );
DBMS_RLS.add_policy (
    object_schema     => 'BI',
    object_name       => 'ATDATEICB',
    policy_name       => 'AT_SP3_POLICY',
    function_schema   => 'SYSMAN',
    policy_function   => 'AT_SPALTEN.AT_SP3',
    sec_relevant_cols => 'VMANNKZ'
 );
end;
/

-- ================================================
-- Achtung: Hier beginnen die Auswertungen
--          SQL-Befehle und Ergebnisse
-- ------------------------------------------

-- Harry - Polizist Nordprovinz:

select NAME , VORNAME,NAMENSZUSATZ,HERKUNFTSLAND, GESCHLECHT,GEBDAT, ERSTEINDAT, LETZTEINDAT,
 LETZTAUSDAT , STAATSANGEH,ZUST_DIENSTS_ST, substr(label_to_char(POL_TAG),1,8) 
 from BI.atdateicb;

NAME                     VORNAME                  NAMENSZUSATZ             HERK G GEBDAT    ERSTEINDA LETZTEIND LETZTAUSD STAA ZUST_DIENSTS_ST  SUBSTR(L
------------------------ ------------------------ ------------------------ ---- - --------- --------- --------- --------- ---- ---------------- --------
PEREZ                    MARIA                                             TELA F 26-MAY-03 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
KWAN                     SALLY                                             USA  F 11-MAY-71 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
HAAS                     CHRISTINE                                         AUS  F 24-AUG-63 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
THOMPSON                 MICHAEL                                           TELA M 02-FEB-78 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
STERN                    IRVING                                            TELA M 07-JUL-75 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
PULASKI                  EVA                                               TELA F 26-MAY-03 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
HENDERSON                EILEEN                                            TELA F 15-MAY-71 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
SPENSER                  THEODORE                                          TELA M 18-DEC-80 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
OCONNELL                 SEAN                                              IRL  M 18-OCT-72 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
NICHOLLS                 HEATHER                                           TELA F 19-JAN-76 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
ADAMSON                  BRUCE                                             TELA M 17-MAY-77 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
PIANKA                   ELIZABETH                                         TELA F 12-APR-80 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
SCOUTTEN                 MARILYN                                           TELA F 21-FEB-79 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
BROWN                    DAVID                                             TELA M 29-MAY-71 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
LUTZ                     JENNIFER                                          TELA F 19-MAR-78 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
JEFFERSON                JAMES                                             TELA M 30-MAY-80 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
MARINO                   SALVATORE                                         TELA M 31-MAR-02 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
JOHNSON                  SYBIL                                             TELA F 05-OCT-76 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
PARKER                   JOHN                                              TELA M 09-JUL-85 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
SMITH                    PHILIP                                            TELA M 27-OCT-76 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
SETRIGHT                 MAUDE                                             TELA F 21-APR-61 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
LEE                      WING                                              TELA M 18-JUL-71 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
GOUNOT                   JASON                                             TELA M 17-MAY-56 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
HEMMINGER                DIAN                                              TELA F 14-AUG-73 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
ORLANDO                  GREG                                              TELA M 18-OCT-72 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
NATZ                     KIM                                               TELA F 19-JAN-76 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
YAMAMOTO                 KIYOSHI                  Kamikaze                 TELA M 05-JAN-81 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
JOHN                     REBA                                              TELA F 19-MAR-78 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
MONTEVERDE               ROBERT                                            TELA M 31-MAR-84 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
SCHWARTZ                 EILEEN                                            TELA F 28-MAR-66 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
SPRINGER                 MICHELLE                                          TELA F 21-APR-61 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP
WONG                     HELENA                                            TELA F 18-JUL-71 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::NP

32 rows selected.


-- Derrick - Kriminaldirektor Ost:

select NAME , VORNAME,NAMENSZUSATZ,HERKUNFTSLAND, GESCHLECHT,GEBDAT, ERSTEINDAT, LETZTEINDAT,
 LETZTAUSDAT , STAATSANGEH,ZUST_DIENSTS_ST, substr(label_to_char(POL_TAG),1,8) 
 from BI.atdateicb;

NAME                     VORNAME                  NAMENSZUSATZ             HERK G GEBDAT    ERSTEINDA LETZTEIND LETZTAUSD STAA ZUST_DIENSTS_ST  SUBSTR(L
------------------------ ------------------------ ------------------------ ---- - --------- --------- --------- --------- ---- ---------------- --------
MEHTA                    RAMLAL                                            IND  M 11-AUG-62 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   TV::OP
ALONZO                   ROY                                               MEX  M 17-MAY-56 13-SEP-06 13-SEP-06           COBA 1.Kommissariat   AT::OP

2 rows selected.



-- Soko - Sonderkommission Anti-Terror Westprovinz:

select NAME , VORNAME,NAMENSZUSATZ,HERKUNFTSLAND, GESCHLECHT,GEBDAT, ERSTEINDAT, GEFEINSTUFUNG,
 LETZTAUSDAT , STAATSANGEH,ZUST_DIENSTS_ST, substr(label_to_char(POL_TAG),1,8) 
 from BI.atdateicb;

NAME                     VORNAME                  NAMENSZUSATZ             HERK G GEBDAT    ERSTEINDA GE LETZTAUSD STAA ZUST_DIENSTS_ST  SUBSTR(L
------------------------ ------------------------ ------------------------ ---- - --------- --------- -- --------- ---- ---------------- --------
GEYER                    JOHN                                              TELA M 15-SEP-55 13-SEP-06 TV           COBA 1.Kommissariat   TV::WP
WALKER                   Johnny                   Die Flasche              SCTL M 25-JUN-82 13-SEP-06 TV           BRIT 1.Kommissariat   TV::WP
SMITH                    DANIEL                                            TELA M 12-NOV-69 13-SEP-06 TV           COBA 1.Kommissariat   TV::WP
Ente                     Dagobert                 Duck                     DISN M 01-JAN-72 02-JUN-00 AT           ENTE WaschPo          AT::WP
Bush                     George                   The Warrior              USA  M 29-FEB-44 01-JAN-96 TT 05-DEC-97 US   3.SK Koelsch     TT::WP

5 rows selected.


-- Schlphut -  Special Agent Schlapphut vom Geheimdienst:

select NAME , VORNAME,NAMENSZUSATZ,HERKUNFTSLAND, GESCHLECHT,GEBDAT, ERSTEINDAT, LETZTEINDAT, GEFEINSTUFUNG
, STAATSANGEH,ZUST_DIENSTS_ST, IDKRIMREG ,BEZTERRORNETZ, IDGEHDIENST,
 substr(label_to_char(POL_TAG),1,8)
from BI.atdateicb;

NAME                     VORNAME                  NAMENSZUSATZ             HERK G GEBDAT    ERSTEINDA LETZTEIND GE STAA ZUST_DIENSTS_ST   IDKRIMREG BEZTERRORNETZ    IDGEHDIENST SUBSTR(L
------------------------ ------------------------ ------------------------ ---- - --------- --------- --------- -- ---- ---------------- ---------- ---------------- ----------- --------
BinImLaden               Ossy                     Der Araber               TELA M 17-APR-49 10-SEP-99 01-OCT-06 TT DEUT 2.Kommissariat         4711 EL KeinerDa             4712 TT::SP
PEREZ                    MARIA                                             TELA F 26-MAY-03 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat              El KeinerDa            45628 TV::NP
KWAN                     SALLY                                             USA  F 11-MAY-71 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat              WhiteHouse Gang              TV::NP
HAAS                     CHRISTINE                                         AUS  F 24-AUG-63 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
THOMPSON                 MICHAEL                                           TELA M 02-FEB-78 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
GEYER                    JOHN                                              TELA M 15-SEP-55 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::WP
STERN                    IRVING                                            TELA M 07-JUL-75 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
PULASKI                  EVA                                               TELA F 26-MAY-03 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
HENDERSON                EILEEN                                            TELA F 15-MAY-71 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
SPENSER                  THEODORE                                          TELA M 18-DEC-80 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
LUCCHESSI                VINCENZO                 El Mafioso               ITA  M 05-NOV-59 13-SEP-06 13-SEP-06 AT ITA  1.Kommissariat                                           AT::SP
OCONNELL                 SEAN                                              IRL  M 18-OCT-72 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
QUINTANA                 DELORES                                           TELA F 15-SEP-55 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::SP
NICHOLLS                 HEATHER                                           TELA F 19-JAN-76 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
ADAMSON                  BRUCE                                             TELA M 17-MAY-77 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
PIANKA                   ELIZABETH                                         TELA F 12-APR-80 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
SCOUTTEN                 MARILYN                                           TELA F 21-FEB-79 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
WALKER                   Johnny                   Die Flasche              SCTL M 25-JUN-82 13-SEP-06 13-SEP-06 TV BRIT 1.Kommissariat                                           TV::WP
BROWN                    DAVID                                             TELA M 29-MAY-71 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
JONES                    WILLIAM                                           TELA M 23-FEB-03 13-SEP-06 13-SEP-06 AT COBA 1.Kommissariat                                           AT::NP
LUTZ                     JENNIFER                                          TELA F 19-MAR-78 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
JEFFERSON                JAMES                                             TELA M 30-MAY-80 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
MARINO                   SALVATORE                                         TELA M 31-MAR-02 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
SMITH                    DANIEL                                            TELA M 12-NOV-69 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::WP
JOHNSON                  SYBIL                                             TELA F 05-OCT-76 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
SCHNEIDER                ETHEL                                             TELA F 28-MAR-76 13-SEP-06 13-SEP-06 AT COBA 1.Kommissariat                                           AT::NP
PARKER                   JOHN                                              TELA M 09-JUL-85 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
SMITH                    PHILIP                                            TELA M 27-OCT-76 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
SETRIGHT                 MAUDE                                             TELA F 21-APR-61 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
MEHTA                    RAMLAL                                            IND  M 11-AUG-62 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::OP
LEE                      WING                                              TELA M 18-JUL-71 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
GOUNOT                   JASON                                             TELA M 17-MAY-56 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
HEMMINGER                DIAN                                              TELA F 14-AUG-73 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
ORLANDO                  GREG                                              TELA M 18-OCT-72 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
NATZ                     KIM                                               TELA F 19-JAN-76 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
YAMAMOTO                 KIYOSHI                  Kamikaze                 TELA M 05-JAN-81 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
JOHN                     REBA                                              TELA F 19-MAR-78 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
MONTEVERDE               ROBERT                                            TELA M 31-MAR-84 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
SCHWARTZ                 EILEEN                                            TELA F 28-MAR-66 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
SPRINGER                 MICHELLE                                          TELA F 21-APR-61 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
WONG                     HELENA                                            TELA F 18-JUL-71 13-SEP-06 13-SEP-06 TV COBA 1.Kommissariat                                           TV::NP
ALONZO                   ROY                                               MEX  M 17-MAY-56 13-SEP-06 13-SEP-06 AT COBA 1.Kommissariat                                           AT::OP
Ente                     Dagobert                 Duck                     DISN M 01-JAN-72 02-JUN-00 02-JUN-00 AT ENTE WaschPo               13455                              AT::WP
Fisher                   Jogi                     Moltow-Cocktail          DEUT M 07-MAY-55 01-AUG-04 01-AUG-04 TT COBA AutobahnPolizei       74747 RAF                    87621 TT::OP
Bush                     George                   The Warrior              USA  M 29-FEB-44 01-JAN-96 01-JAN-06 TT US   3.SK Koelsch         876554 WhiteHouse Gang        12345 TT::WP

45 rows selected.



-- Bond - Special Agent James Bond mit Sonderbefugnissen:

select NAME ,NAMENSZUSATZ,HERKUNFTSLAND, GEBDAT, GEFEINSTUFUNG , STAATSANGEH
, ZUST_DIENSTS_ST, IDKRIMREG ,BEZTERRORNETZ, IDGEHDIENST
, substr(label_to_char(POL_TAG),1,8)
 from BI.atdateicb
 where vmannkz is not null;

NAME                     NAMENSZUSATZ             HERK GEBDAT    GE STAA ZUST_DIENSTS_ST   IDKRIMREG BEZTERRORNETZ    IDGEHDIENST SUBSTR(L
------------------------ ------------------------ ---- --------- -- ---- ---------------- ---------- ---------------- ----------- --------
BinImLaden               Der Araber               TELA 17-APR-49 TT DEUT 2.Kommissariat         4711 EL KeinerDa             4712 TT::SP
Ente                     Duck                     DISN 01-JAN-72 AT ENTE WaschPo               13455                              AT::WP
Fisher                   Moltow-Cocktail          DEUT 07-MAY-55 TT COBA AutobahnPolizei       74747 RAF                    87621 TT::OP

3 rows selected.




